# Player: huggingface_DeepSeek-V3-0324_PayoffMaximizer_B (as Player B)
# Meta-Round: 10
# Experiment: PMxPM, Run: 3
# API: huggingface, Model: deepseek-ai/DeepSeek-V3-0324
# Based on textual strategy: huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR10_strategy.txt
# LLM Suggested Fallback: D

def huggingface_DeepSeek_V3_0324_PayoffMaximizer_B_MR10(my_history: list, opp_history: list, opponent_program_code: str) -> str:
    current_round = len(my_history) + 1
    
    # Check for always cooperate or always defect in opponent's code
    always_cooperate = "return 'C'" in opponent_program_code or "always cooperate" in opponent_program_code.lower()
    always_defect = "return 'D'" in opponent_program_code or "always defect" in opponent_program_code.lower()
    
    if always_cooperate:
        return "D"
    if always_defect:
        return "C"
    
    # Round 1: Cooperate
    if current_round == 1:
        return "C"
    
    # Round 10: Defect unconditionally
    if current_round == 10:
        return "D"
    
    # Tit-for-tat with a twist
    if opp_history[-1] == "C":
        return "C"
    else:
        return "D"